/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnSourceFromGraveyardToBattlefieldEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessAllEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.s.SephirothFallenHeroEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ModifiedPredicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class SephirothFallenHero
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("a modified creature");

    public SephirothFallenHero(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{3}{R}{W}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.AVATAR);
        this.subtype.add((Object)SubType.SOLDIER);
        this.power = new MageInt(7);
        this.toughness = new MageInt(5);
        AttacksTriggeredAbility ability = new AttacksTriggeredAbility((Effect)new SephirothFallenHeroEffect());
        ability.addEffect((Effect)new SetBasePowerToughnessAllEffect(7, 5, Duration.EndOfTurn, filter).setText("until end of turn, each modified creature you control has base power and toughness 7/5"));
        ability.addTarget((Target)new TargetCreaturePermanent());
        this.addAbility(ability.withFlavorWord("Jenova Cells"));
        ability = new SimpleActivatedAbility(Zone.GRAVEYARD, (Effect)new ReturnSourceFromGraveyardToBattlefieldEffect(true), (Cost)new GenericManaCost(3));
        ability.addCost((Cost)new SacrificeTargetCost(filter));
        this.addAbility(ability.withFlavorWord("The Reunion"));
    }

    private SephirothFallenHero(SephirothFallenHero card) {
        super((CardImpl)card);
    }

    public SephirothFallenHero copy() {
        return new SephirothFallenHero(this);
    }

    static {
        filter.add((Predicate)ModifiedPredicate.instance);
    }
}

