/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class SeraphDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    UUID seraph;

    SeraphDelayedTriggeredAbility(Effect effect, UUID seraph) {
        super(effect, Duration.EndOfGame, true);
        this.seraph = seraph;
    }

    private SeraphDelayedTriggeredAbility(SeraphDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.seraph = ability.seraph;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOST_CONTROL || event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getTargetId().equals(this.seraph);
    }

    public SeraphDelayedTriggeredAbility copy() {
        return new SeraphDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "Control of Seraph was lost, sacrifice this.";
    }
}

