/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.s.SeraphicGreatswordEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SeraphicGreatswordTriggeredAbility
extends TriggeredAbilityImpl {
    public SeraphicGreatswordTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private SeraphicGreatswordTriggeredAbility(SeraphicGreatswordTriggeredAbility abiltity) {
        super((TriggeredAbilityImpl)abiltity);
    }

    public SeraphicGreatswordTriggeredAbility copy() {
        return new SeraphicGreatswordTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        block5: {
            block4: {
                Permanent equipment = game.getPermanent(this.sourceId);
                if (equipment == null || equipment.getAttachedTo() == null || !event.getSourceId().equals(equipment.getAttachedTo())) {
                    return false;
                }
                Player player = game.getPlayer(event.getTargetId());
                if (player == null) break block4;
                if (player.getLife() >= game.getState().getPlayersInRange(this.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).mapToInt(Player::getLife).max().orElse(0)) break block5;
            }
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new SeraphicGreatswordEffect(event.getTargetId()));
        return true;
    }

    public String getRule() {
        return "Whenever equipped creature attacks the player with the most life or tied for most life, create a 4/4 white Angel creature token with flying that's tapped and attacking that player.";
    }
}

