/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SerpentineAmbushEffect
extends ContinuousEffectImpl {
    SerpentineAmbushEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "until end of turn, target creature becomes a blue Serpent with base power and toughness 5/5";
    }

    private SerpentineAmbushEffect(SerpentineAmbushEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SerpentineAmbushEffect copy() {
        return new SerpentineAmbushEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllCreatureTypes(game);
                permanent.addSubType(game, new SubType[]{SubType.SERPENT});
                return true;
            }
            case ColorChangingEffects_5: {
                permanent.getColor(game).setColor(ObjectColor.BLUE);
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(5);
                permanent.getToughness().setModifiedBaseValue(5);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case ColorChangingEffects_5: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

