/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.replacement.DealtDamageToCreatureBySourceDies;
import mage.abilities.keyword.DevoidAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.s.SerpentineSpikeEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.other.AnotherTargetPredicate;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;
import mage.watchers.Watcher;
import mage.watchers.common.DamagedByWatcher;

public final class SerpentineSpike
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("another creature");

    public SerpentineSpike(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{5}{R}{R}");
        this.addAbility((Ability)new DevoidAbility(this.color));
        this.getSpellAbility().addEffect((Effect)new SerpentineSpikeEffect());
        this.getSpellAbility().addTarget(new TargetCreaturePermanent().withChooseHint("2 damage").setTargetTag(1));
        this.getSpellAbility().addTarget(new TargetPermanent((FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE_TARGET_2).withChooseHint("3 damage").setTargetTag(2));
        this.getSpellAbility().addTarget(new TargetPermanent(filter).withChooseHint("4 damage").setTargetTag(3));
        this.getSpellAbility().addEffect((Effect)new DealtDamageToCreatureBySourceDies((Card)this, Duration.EndOfTurn).setText("If a creature dealt damage this way would die this turn, exile it instead"));
        this.getSpellAbility().addWatcher((Watcher)new DamagedByWatcher(false));
    }

    private SerpentineSpike(SerpentineSpike card) {
        super((CardImpl)card);
    }

    public SerpentineSpike copy() {
        return new SerpentineSpike(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)new AnotherTargetPredicate(3));
    }
}

