/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.s.SerraParagonWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;

class SerraParagonPlayEffect
extends AsThoughEffectImpl {
    SerraParagonPlayEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "once during each of your turns, you may play a land card from your graveyard or cast a permanent spell with mana value 3 or less from your graveyard. If you do, it gains \"When this permanent is put into a graveyard from the battlefield, exile it and you gain 2 life.\"";
    }

    private SerraParagonPlayEffect(SerraParagonPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public SerraParagonPlayEffect copy() {
        return new SerraParagonPlayEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card card = game.getCard(objectId);
        return card != null && card.isOwnedBy(affectedControllerId) && source.isControlledBy(affectedControllerId) && game.isActivePlayer(affectedControllerId) && !SerraParagonWatcher.checkPlayer(source, game) && card.isPermanent(game) && (card.isLand(game) || card.getManaValue() <= 3) && Zone.GRAVEYARD.match(game.getState().getZone(card.getId()));
    }
}

