/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.s.SerraParagonGainEffect;
import mage.cards.s.SerraParagonWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class SerraParagonTriggeredAbility
extends TriggeredAbilityImpl {
    SerraParagonTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
        this.usesStack = false;
        this.setRuleVisible(false);
        this.addWatcher(new SerraParagonWatcher());
    }

    private SerraParagonTriggeredAbility(SerraParagonTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SerraParagonTriggeredAbility copy() {
        return new SerraParagonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST || event.getType() == GameEvent.EventType.LAND_PLAYED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.isControlledBy(event.getPlayerId()) && event.hasApprovingIdentifier(MageIdentifier.SerraParagonWatcher)) {
            this.getEffects().clear();
            this.addEffect((Effect)new SerraParagonGainEffect(new MageObjectReference(event.getSourceId(), game)));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "";
    }
}

