/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class SerumPowderReplaceEffect
extends ReplacementEffectImpl {
    SerumPowderReplaceEffect() {
        super(Duration.EndOfGame, Outcome.Detriment);
        this.staticText = "Any time you could mulligan and this card is in your hand, you may exile all the cards from your hand, then draw that many cards";
    }

    private SerumPowderReplaceEffect(SerumPowderReplaceEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Card sourceCard = game.getCard(source.getSourceId());
        if (controller != null && sourceCard != null) {
            if (!controller.chooseUse(this.outcome, "Exile all cards from hand and draw that many cards?", source, game)) {
                return false;
            }
            int cardsHand = controller.getHand().size();
            if (cardsHand > 0) {
                CardsImpl cards = new CardsImpl((Collection)controller.getHand());
                for (Card card : cards.getCards(game)) {
                    card.moveToExile(null, null, source, game);
                }
                controller.drawCards(cardsHand, source, game);
            }
            game.informPlayers(sourceCard.getLogName() + ": " + controller.getLogName() + " exiles hand and draws " + cardsHand + " card(s)");
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAN_TAKE_MULLIGAN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public SerumPowderReplaceEffect copy() {
        return new SerumPowderReplaceEffect(this);
    }
}

