/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class SettleTheScoreEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("planeswalker you control");

    public SettleTheScoreEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put two loyalty counters on a planeswalker you control";
    }

    private SettleTheScoreEffect(SettleTheScoreEffect effect) {
        super((OneShotEffect)effect);
    }

    public SettleTheScoreEffect copy() {
        return new SettleTheScoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        if (target.choose(Outcome.Benefit, player.getId(), source.getSourceId(), source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
            permanent.addCounters(CounterType.LOYALTY.createInstance(2), source.getControllerId(), source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)CardType.PLANESWALKER.getPredicate());
    }
}

