/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class SettleTheWreckageEffect
extends OneShotEffect {
    SettleTheWreckageEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile all attacking creatures target player controls. That player may search their library for that many basic land cards, put those cards onto the battlefield tapped, then shuffle";
    }

    private SettleTheWreckageEffect(SettleTheWreckageEffect effect) {
        super((OneShotEffect)effect);
    }

    public SettleTheWreckageEffect copy() {
        return new SettleTheWreckageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || player == null) {
            return false;
        }
        HashSet toExile = new HashSet(game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_ATTACKING_CREATURES, player.getId(), game));
        int attackers = toExile.size();
        if (attackers == 0) {
            return true;
        }
        controller.moveCards(toExile, Zone.EXILED, source, game);
        game.processAction();
        TargetCardInLibrary target = new TargetCardInLibrary(0, attackers, (FilterCard)(attackers > 1 ? StaticFilters.FILTER_CARD_BASIC_LANDS : StaticFilters.FILTER_CARD_BASIC_LAND));
        if (player.chooseUse(Outcome.PutLandInPlay, "Search your library for " + target.getDescription() + '?', source, game) && player.searchLibrary(target, source, game) && !target.getTargets().isEmpty()) {
            player.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        return true;
    }
}

