/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SewerNemesisTriggeredAbility
extends TriggeredAbilityImpl {
    public SewerNemesisTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MillCardsTargetEffect(1), false);
    }

    private SewerNemesisTriggeredAbility(SewerNemesisTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID playerId = (UUID)game.getState().getValue(this.getSourceId() + "_player");
        if (playerId.equals(event.getPlayerId())) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(playerId));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever the chosen player casts a spell, that player mills a card.";
    }

    public SewerNemesisTriggeredAbility copy() {
        return new SewerNemesisTriggeredAbility(this);
    }
}

