/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ShackleSlingerEffect
extends OneShotEffect {
    ShackleSlingerEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target creature an opponent controls. If it's tapped, put a stun counter on it. Otherwise, tap it";
    }

    private ShackleSlingerEffect(ShackleSlingerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShackleSlingerEffect copy() {
        return new ShackleSlingerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        if (!permanent.isTapped()) {
            return permanent.tap(source, game);
        }
        return permanent.addCounters(CounterType.STUN.createInstance(), source, game);
    }
}

