/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class ShadowOfTheEnemyCastFromExileEffect
extends AsThoughEffectImpl {
    ShadowOfTheEnemyCastFromExileEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.Benefit);
        this.staticText = "You may cast spells from among them as long as they remain exiled";
    }

    private ShadowOfTheEnemyCastFromExileEffect(ShadowOfTheEnemyCastFromExileEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public ShadowOfTheEnemyCastFromExileEffect copy() {
        return new ShadowOfTheEnemyCastFromExileEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        UUID cardId = this.getTargetPointer().getFirst(game, source);
        if (cardId == null) {
            this.discard();
            return false;
        }
        Card theCard = game.getCard(objectId);
        if (theCard == null || theCard.isLand(game)) {
            return false;
        }
        objectId = theCard.getMainCard().getId();
        if (objectId.equals(cardId) && affectedControllerId.equals(source.getControllerId())) {
            Card card = game.getCard(objectId);
            return card != null;
        }
        return false;
    }
}

