/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ShahOfNaarIsleEffect
extends OneShotEffect {
    ShahOfNaarIsleEffect() {
        super(Outcome.DrawCard);
        this.staticText = "each opponent may draw up to three cards";
    }

    private ShahOfNaarIsleEffect(ShahOfNaarIsleEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShahOfNaarIsleEffect copy() {
        return new ShahOfNaarIsleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getOpponents(controller.getId())) {
                Player opponent = game.getPlayer(playerId);
                if (opponent == null) continue;
                int number = opponent.getAmount(0, 3, "Draw how many cards?", source, game);
                opponent.drawCards(number, source, game);
            }
            return true;
        }
        return false;
    }
}

