/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.io.Serializable;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.DiesCreatureTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.counter.AddCountersAllEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.CardSetInfo;
import mage.cards.ModalDoubleFacedCard;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.EnteredThisTurnPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class ShaileDeanOfRadiance
extends ModalDoubleFacedCard {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("another target creature");
    private static final FilterPermanent shaileFilter = new FilterControlledCreaturePermanent("creature that entered the battlefield under your control this turn");

    public ShaileDeanOfRadiance(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new SuperType[]{SuperType.LEGENDARY}, new CardType[]{CardType.CREATURE}, new SubType[]{SubType.BIRD, SubType.CLERIC}, "{1}{W}", "Embrose, Dean of Shadow", new SuperType[]{SuperType.LEGENDARY}, new CardType[]{CardType.CREATURE}, new SubType[]{SubType.HUMAN, SubType.WARLOCK}, "{2}{B}{B}");
        this.getLeftHalfCard().setPT(1, 1);
        this.getLeftHalfCard().addAbility((Ability)FlyingAbility.getInstance());
        this.getLeftHalfCard().addAbility((Ability)VigilanceAbility.getInstance());
        this.getLeftHalfCard().addAbility((Ability)new SimpleActivatedAbility((Effect)new AddCountersAllEffect(CounterType.P1P1.createInstance(), shaileFilter), (Cost)new TapSourceCost()));
        this.getRightHalfCard().setPT(4, 4);
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()), (Cost)new TapSourceCost());
        ability.addEffect((Effect)new DamageTargetEffect(2).concatBy(", then").setText("{this} deals 2 damage to that creature"));
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        this.getRightHalfCard().addAbility((Ability)ability);
        this.getRightHalfCard().addAbility((Ability)new DiesCreatureTriggeredAbility((Effect)new DrawCardSourceControllerEffect(1), false, (FilterPermanent)StaticFilters.FILTER_A_CONTROLLED_CREATURE_P1P1));
    }

    private ShaileDeanOfRadiance(ShaileDeanOfRadiance card) {
        super((ModalDoubleFacedCard)card);
    }

    public ShaileDeanOfRadiance copy() {
        return new ShaileDeanOfRadiance(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        shaileFilter.add((Predicate)EnteredThisTurnPredicate.instance);
        shaileFilter.add((Predicate & Serializable)(input, game) -> !input.checkControlChanged(game));
    }
}

