/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.players.Player;

class ShamanOfForgottenWaysEffect
extends OneShotEffect {
    public ShamanOfForgottenWaysEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player's life total becomes the number of creatures they control";
    }

    private ShamanOfForgottenWaysEffect(ShamanOfForgottenWaysEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShamanOfForgottenWaysEffect copy() {
        return new ShamanOfForgottenWaysEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                int numberCreatures = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, playerId, game).size();
                player.setLife(numberCreatures, game, source);
            }
            return true;
        }
        return false;
    }
}

