/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class ShapeAnew
extends CardImpl {
    public ShapeAnew(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{3}{U}");
        this.getSpellAbility().addEffect((Effect)new ShapeAnewEffect());
        this.getSpellAbility().addTarget((Target)new TargetPermanent((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT_AN));
    }

    private ShapeAnew(ShapeAnew card) {
        super((CardImpl)card);
    }

    public ShapeAnew copy() {
        return new ShapeAnew(this);
    }

    private static class ShapeAnewEffect
    extends OneShotEffect {
        public ShapeAnewEffect() {
            super(Outcome.PutCardInPlay);
            this.staticText = "The controller of target artifact sacrifices it, then reveals cards from the top of their library until they reveal an artifact card. That player puts that card onto the battlefield, then shuffles all other cards revealed this way into their library";
        }

        private ShapeAnewEffect(ShapeAnewEffect effect) {
            super((OneShotEffect)effect);
        }

        public boolean apply(Game game, Ability source) {
            Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetPermanent == null) {
                return false;
            }
            targetPermanent.sacrifice(source, game);
            Player targetController = game.getPlayer(targetPermanent.getControllerId());
            if (targetController == null) {
                return false;
            }
            CardsImpl revealed = new CardsImpl();
            Card artifactCard = null;
            for (Card card : targetController.getLibrary().getCards(game)) {
                revealed.add(card);
                if (!card.isArtifact(game)) continue;
                artifactCard = card;
                break;
            }
            targetController.revealCards(source, (Cards)revealed, game);
            if (artifactCard != null) {
                targetController.moveCards(artifactCard, Zone.BATTLEFIELD, source, game);
            }
            targetController.shuffleLibrary(source, game);
            return true;
        }

        public ShapeAnewEffect copy() {
            return new ShapeAnewEffect(this);
        }
    }
}

