/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ShapeStealerEffect
extends OneShotEffect {
    ShapeStealerEffect() {
        super(Outcome.Detriment);
        this.staticText = "change {this}'s base power and toughness to that creature's power and toughness until end of turn";
    }

    private ShapeStealerEffect(ShapeStealerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShapeStealerEffect copy() {
        return new ShapeStealerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller == null || permanent == null) {
            return false;
        }
        SetBasePowerToughnessSourceEffect effect = new SetBasePowerToughnessSourceEffect(permanent.getPower().getValue(), permanent.getToughness().getValue(), Duration.EndOfTurn);
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

