/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class ShapesharerEffect
extends OneShotEffect {
    ShapesharerEffect() {
        super(Outcome.Copy);
        this.staticText = "Target Shapeshifter becomes a copy of target creature until your next turn.";
    }

    private ShapesharerEffect(ShapesharerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShapesharerEffect copy() {
        return new ShapesharerEffect(this);
    }

    public boolean apply(Game game, Ability ability) {
        Permanent copyFrom;
        Permanent copyTo = game.getPermanent(this.getTargetPointer().getFirst(game, ability));
        if (copyTo != null && (copyFrom = game.getPermanentOrLKIBattlefield(((Target)ability.getTargets().get(1)).getFirstTarget())) != null) {
            game.copyPermanent(Duration.UntilYourNextTurn, copyFrom, copyTo.getId(), ability, (CopyApplier)new EmptyCopyApplier());
        }
        return true;
    }
}

