/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.ManaPoolItem;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

class ShareTheSpoilsSpendAnyManaEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    ShareTheSpoilsSpendAnyManaEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.WhileOnBattlefield, Outcome.Benefit);
    }

    private ShareTheSpoilsSpendAnyManaEffect(ShareTheSpoilsSpendAnyManaEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public ShareTheSpoilsSpendAnyManaEffect copy() {
        return new ShareTheSpoilsSpendAnyManaEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        int targetZCC;
        UUID mainCardId = CardUtil.getMainCardId((Game)game, (UUID)sourceId);
        if (this.getTargetPointer() == null) {
            return false;
        }
        UUID targetUUID = ((FixedTarget)this.getTargetPointer()).getTarget();
        if (mainCardId != targetUUID) {
            return false;
        }
        int mainCardZCC = game.getState().getZoneChangeCounter(mainCardId);
        if (mainCardZCC <= (targetZCC = game.getState().getZoneChangeCounter(targetUUID)) + 1) {
            return true;
        }
        this.discard();
        return false;
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        return mana.getFirstAvailable();
    }
}

