/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.s.SharedFate;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class SharedFatePlayEffect
extends AsThoughEffectImpl {
    SharedFatePlayEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Each player may look at and play cards they exiled with {this}";
    }

    private SharedFatePlayEffect(SharedFatePlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public SharedFatePlayEffect copy() {
        return new SharedFatePlayEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (game.getState().getZone(objectId) == Zone.EXILED) {
            Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
            UUID exileId = CardUtil.getExileZoneId((String)SharedFate.prepareExileKey(game, source, sourcePermanent, affectedControllerId), (Game)game);
            ExileZone exileZone = game.getExile().getExileZone(exileId);
            return exileZone != null && exileZone.contains((Object)objectId);
        }
        return false;
    }
}

