/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.SharkToken;
import mage.game.stack.Spell;

class SharkTyphoonCastEffect
extends OneShotEffect {
    SharkTyphoonCastEffect() {
        super(Outcome.Benefit);
        this.staticText = "create an X/X blue Shark creature token with flying, where X is that spell's mana value";
    }

    private SharkTyphoonCastEffect(SharkTyphoonCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public SharkTyphoonCastEffect copy() {
        return new SharkTyphoonCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        int xValue = 0;
        if (spell != null) {
            xValue = spell.getManaValue();
        }
        return new SharkToken(xValue).putOntoBattlefield(1, game, source, source.getControllerId());
    }
}

