/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldAllTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.effects.keyword.InvestigateEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class SharpEyedRookieTriggeredAbility
extends EntersBattlefieldAllTriggeredAbility {
    SharpEyedRookieTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()), (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, false);
        this.addEffect((Effect)new InvestigateEffect().concatBy("and"));
        this.setTriggerPhrase("Whenever a creature you control enters, if its power is greater than {this}'s power or its toughness is greater than {this}'s toughness, ");
    }

    private SharpEyedRookieTriggeredAbility(SharpEyedRookieTriggeredAbility ability) {
        super((EntersBattlefieldAllTriggeredAbility)ability);
    }

    public SharpEyedRookieTriggeredAbility copy() {
        return new SharpEyedRookieTriggeredAbility(this);
    }

    public boolean checkInterveningIfClause(Game game) {
        Permanent sourcePermanent = this.getSourcePermanentOrLKI(game);
        return sourcePermanent != null && sourcePermanent.isCreature(game) && CardUtil.getEffectValueFromAbility((Ability)this, (String)"permanentEnteringBattlefield", Permanent.class).filter(permanent -> permanent.isCreature(game)).filter(permanent -> sourcePermanent.getPower().getValue() < permanent.getPower().getValue() || sourcePermanent.getToughness().getValue() < permanent.getToughness().getValue()).isPresent();
    }
}

