/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ShroudAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ShelteringPrayersEffect
extends ContinuousEffectImpl {
    ShelteringPrayersEffect() {
        super(Duration.WhileOnBattlefield, Outcome.AddAbility);
        this.staticText = "Basic lands each player controls have shroud as long as that player controls three or fewer lands.";
        this.dependencyTypes.add(DependencyType.AddingAbility);
    }

    private ShelteringPrayersEffect(ShelteringPrayersEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ShelteringPrayersEffect copy() {
        return new ShelteringPrayersEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterLandPermanent(), playerId, game).size() >= 4) continue;
            for (Permanent land : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterLandPermanent(), playerId, game)) {
                if (land == null || !land.isBasic(game)) continue;
                switch (layer) {
                    case AbilityAddingRemovingEffects_6: {
                        if (sublayer != SubLayer.NA) break;
                        land.getAbilities().add((Object)ShroudAbility.getInstance());
                    }
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return Layer.AbilityAddingRemovingEffects_6 == layer;
    }
}

