/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ShelteringWordEffect
extends OneShotEffect {
    ShelteringWordEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to that creature's toughness";
    }

    private ShelteringWordEffect(ShelteringWordEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShelteringWordEffect copy() {
        return new ShelteringWordEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount;
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player != null && permanent != null && (amount = permanent.getToughness().getValue()) > 0) {
            player.gainLife(amount, game, source);
            return true;
        }
        return false;
    }
}

