/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.TargetPermanent;

class ShieldDancerRedirectionEffect
extends RedirectionEffect {
    ShieldDancerRedirectionEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "The next time target attacking creature would deal combat damage to {this} this turn, that creature deals that damage to itself instead";
    }

    private ShieldDancerRedirectionEffect(ShieldDancerRedirectionEffect effect) {
        super((RedirectionEffect)effect);
    }

    public ShieldDancerRedirectionEffect copy() {
        return new ShieldDancerRedirectionEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(source.getSourceId()) && event.getSourceId().equals(((Target)source.getTargets().get(0)).getFirstTarget())) {
            DamageEvent damageEvent = (DamageEvent)event;
            if (damageEvent.isCombatDamage()) {
                TargetPermanent target = new TargetPermanent();
                target.add(((Target)source.getTargets().get(0)).getFirstTarget(), game);
                this.redirectTarget = target;
            }
            return true;
        }
        return false;
    }
}

