/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.TargetSource;

class ShieldmageAdvocateEffect
extends PreventionEffectImpl {
    protected final TargetSource targetSource;

    public ShieldmageAdvocateEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false);
        this.staticText = "Prevent all damage that would be dealt to any target this turn by a source of your choice";
        this.targetSource = new TargetSource();
    }

    private ShieldmageAdvocateEffect(ShieldmageAdvocateEffect effect) {
        super((PreventionEffectImpl)effect);
        this.targetSource = effect.targetSource.copy();
    }

    public ShieldmageAdvocateEffect copy() {
        return new ShieldmageAdvocateEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.targetSource.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        this.preventDamageAction(event, source, game);
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getTargetId().equals(this.getTargetPointer().getFirst(game, source)) && event.getSourceId().equals(this.targetSource.getFirstTarget());
    }
}

