/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Iterator;
import java.util.List;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ShieldsOfVelisVelGainEffect
extends ContinuousEffectImpl {
    ShieldsOfVelisVelGainEffect() {
        super(Duration.EndOfTurn, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Neutral);
        this.staticText = "and gain all creature types until end of turn";
    }

    private ShieldsOfVelisVelGainEffect(ShieldsOfVelisVelGainEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ShieldsOfVelisVelGainEffect copy() {
        return new ShieldsOfVelisVelGainEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            List creatures = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getFirstTarget(), game);
            for (Permanent creature : creatures) {
                this.affectedObjectList.add(new MageObjectReference((MageObject)creature, game));
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        Iterator it = this.affectedObjectList.iterator();
        while (it.hasNext()) {
            Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
            if (permanent != null) {
                permanent.setIsAllCreatureTypes(game, true);
                continue;
            }
            it.remove();
        }
        return true;
    }
}

