/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.util.CardUtil;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class ShiftingWoodlandCopyEffect
extends OneShotEffect {
    ShiftingWoodlandCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "{this} becomes a copy of target permanent card in your graveyard until end of turn";
    }

    private ShiftingWoodlandCopyEffect(ShiftingWoodlandCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShiftingWoodlandCopyEffect copy() {
        return new ShiftingWoodlandCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            return false;
        }
        Card copyFromCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (copyFromCard == null) {
            return false;
        }
        PermanentCard blueprint = new PermanentCard(CardUtil.getDefaultCardSideForBattlefield((Game)game, (Card)copyFromCard), source.getControllerId(), game);
        game.copyPermanent(Duration.EndOfTurn, (Permanent)blueprint, sourcePermanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
        return true;
    }
}

