/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldWithCounterTargetEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class ShilgengarSireOfFamineEffect
extends OneShotEffect {
    ShilgengarSireOfFamineEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return each creature card from your graveyard to the battlefield with a finality counter on it. Those creatures are Vampires in addition to their other types.";
    }

    private ShilgengarSireOfFamineEffect(ShilgengarSireOfFamineEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShilgengarSireOfFamineEffect copy() {
        return new ShilgengarSireOfFamineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        ReturnFromGraveyardToBattlefieldWithCounterTargetEffect effect = new ReturnFromGraveyardToBattlefieldWithCounterTargetEffect(new Counter[]{CounterType.FINALITY.createInstance()});
        effect.setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game));
        effect.apply(game, source);
        game.processAction();
        List permanents = cards.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (!permanents.isEmpty()) {
            game.addEffect(new AddCardSubTypeTargetEffect(SubType.VAMPIRE, Duration.Custom).setTargetPointer((TargetPointer)new FixedTargets(permanents, game)), source);
        }
        return true;
    }
}

