/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.common.PutOnLibrarySourceEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class ShivanWumpusEffect
extends PutOnLibrarySourceEffect {
    ShivanWumpusEffect() {
        super(true);
        this.staticText = "any player may sacrifice a land. If a player does, put {this} on top of its owner's library";
    }

    private ShivanWumpusEffect(ShivanWumpusEffect effect) {
        super((PutOnLibrarySourceEffect)effect);
    }

    public ShivanWumpusEffect copy() {
        return new ShivanWumpusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            boolean costPaid = false;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_LAND);
                Player player = game.getPlayer(playerId);
                if (player == null || !cost.canPay(source, source, playerId, game) || !player.chooseUse(Outcome.Sacrifice, "Sacrifice a land?", source, game) || !cost.pay(source, game, source, playerId, true, null)) continue;
                costPaid = true;
            }
            if (costPaid) {
                super.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

