/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ShorecrasherElementalEffect
extends OneShotEffect {
    ShorecrasherElementalEffect() {
        super(Outcome.Neutral);
        this.staticText = "Exile {this}, then return it to the battlefield face down under its owner's control";
    }

    private ShorecrasherElementalEffect(ShorecrasherElementalEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShorecrasherElementalEffect copy() {
        return new ShorecrasherElementalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent shorecrasherElemental = game.getPermanent(source.getSourceId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && shorecrasherElemental != null && sourceObject != null && new MageObjectReference(sourceObject, game).refersTo((MageObject)shorecrasherElemental, game)) {
            Card card;
            if (controller.moveCards((Card)shorecrasherElemental, Zone.EXILED, source, game) && (card = game.getExile().getCard(source.getSourceId(), game)) != null) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game, false, true, true, null);
            }
            return true;
        }
        return false;
    }
}

