/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ShowstoppingSurpriseEffect
extends OneShotEffect {
    ShowstoppingSurpriseEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target creature you control. Turn it face up if it's face down. Then it deals damage equal to its power to each other creature";
    }

    private ShowstoppingSurpriseEffect(ShowstoppingSurpriseEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShowstoppingSurpriseEffect copy() {
        return new ShowstoppingSurpriseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int power;
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        if (permanent.isFaceDown(game)) {
            permanent.turnFaceUp(source, game, source.getControllerId());
            game.processAction();
        }
        if ((power = permanent.getPower().getValue()) < 1) {
            return true;
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (creature.getId().equals(permanent.getId())) continue;
            creature.damage(power, permanent.getId(), source, game);
        }
        return true;
    }
}

