/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.ExchangeControlTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledPermanent;

public final class ShrewdNegotiation
extends CardImpl {
    private static final String rule = "Exchange control of target artifact you control and target artifact or creature you don't control";
    private static final FilterPermanent filter = new FilterPermanent("artifact or creature you don't control");

    public ShrewdNegotiation(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{4}{U}");
        this.getSpellAbility().addEffect((Effect)new ExchangeControlTargetEffect(Duration.EndOfGame, rule, false, true));
        this.getSpellAbility().addTarget((Target)new TargetControlledPermanent((FilterControlledPermanent)new FilterControlledArtifactPermanent("artifact you control")));
        this.getSpellAbility().addTarget((Target)new TargetPermanent(filter));
    }

    private ShrewdNegotiation(ShrewdNegotiation card) {
        super((CardImpl)card);
    }

    public ShrewdNegotiation copy() {
        return new ShrewdNegotiation(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
    }
}

