/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ShriekgeistTriggeredAbility
extends TriggeredAbilityImpl {
    public ShriekgeistTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MillCardsTargetEffect(2));
    }

    private ShriekgeistTriggeredAbility(ShriekgeistTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ShriekgeistTriggeredAbility copy() {
        return new ShriekgeistTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        if (damageEvent.isCombatDamage() && event.getSourceId().equals(this.getSourceId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} deals combat damage to a player, that player mills two cards.";
    }
}

