/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;

class ShrineOfPiercingVisionEffect
extends OneShotEffect {
    ShrineOfPiercingVisionEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Look at the top X cards of your library, where X is the number of charge counters on {this}. Put one of those cards into your hand and the rest on the bottom of your library in any order";
    }

    private ShrineOfPiercingVisionEffect(ShrineOfPiercingVisionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShrineOfPiercingVisionEffect copy() {
        return new ShrineOfPiercingVisionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        if (player == null || permanent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, permanent.getCounters(game).getCount(CounterType.CHARGE)));
        if (!cards.isEmpty()) {
            Card card;
            player.lookAtCards(source, null, (Cards)cards, game);
            TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to put into your hand"));
            if (player.choose(Outcome.DrawCard, (Cards)cards, target, source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
                cards.remove(card);
                player.moveCards(card, Zone.HAND, source, game);
            }
            player.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
        }
        return true;
    }
}

