/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.VariableCostImpl;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;

class SidisiRegentOfTheMireCost
extends VariableCostImpl {
    public SidisiRegentOfTheMireCost() {
        super(VariableCostType.NORMAL, "mana value X");
        this.text = "Sacrifice a creature you control with mana value X other than {this}";
    }

    protected SidisiRegentOfTheMireCost(SidisiRegentOfTheMireCost cost) {
        super((VariableCostImpl)cost);
    }

    public SidisiRegentOfTheMireCost copy() {
        return new SidisiRegentOfTheMireCost(this);
    }

    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("another creature with mana value X");
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, xValue));
        return new SacrificeTargetCost((FilterPermanent)filter);
    }

    public int getMaxValue(Ability source, Game game) {
        return game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE, source.getControllerId(), source, game).stream().mapToInt(MageObject::getManaValue).max().orElse(0);
    }
}

