/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SiegeBehemothEffect
extends AsThoughEffectImpl {
    SiegeBehemothEffect() {
        super(AsThoughEffectType.DAMAGE_NOT_BLOCKED, Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "As long as {this} is attacking, for each creature you control, you may have that creature assign its combat damage as though it weren't blocked";
    }

    private SiegeBehemothEffect(SiegeBehemothEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent != null && sourcePermanent.isAttacking()) {
            Player controller = game.getPlayer(source.getControllerId());
            Permanent otherCreature = game.getPermanent(sourceId);
            if (controller != null && otherCreature != null && otherCreature.isControlledBy(controller.getId())) {
                return controller.chooseUse(Outcome.Damage, "Have " + otherCreature.getLogName() + " assign damage as though it weren't blocked?", source, game);
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public SiegeBehemothEffect copy() {
        return new SiegeBehemothEffect(this);
    }
}

