/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SiegeDragonDamageEffect
extends OneShotEffect {
    SiegeDragonDamageEffect() {
        super(Outcome.Damage);
    }

    private SiegeDragonDamageEffect(SiegeDragonDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public SiegeDragonDamageEffect copy() {
        return new SiegeDragonDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID defendingPlayerId = game.getCombat().getDefendingPlayerId(source.getSourceId(), game);
        if (defendingPlayerId != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new ControllerIdPredicate(defendingPlayerId));
            filter.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
            List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game);
            for (Permanent permanent : permanents) {
                permanent.damage(2, source.getSourceId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }
}

