/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.SigardasSplendor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SigardasSplendorDrawEffect
extends OneShotEffect {
    SigardasSplendorDrawEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card if your life total is greater than or equal to the last noted life total for {this}. Then note your life total";
    }

    private SigardasSplendorDrawEffect(SigardasSplendorDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public SigardasSplendorDrawEffect copy() {
        return new SigardasSplendorDrawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int notedLife;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        String key = SigardasSplendor.getKey(game, source, 0);
        Object object = game.getState().getValue(key);
        int n = notedLife = object instanceof Integer ? (Integer)object : Integer.MIN_VALUE;
        if (player.getLife() >= notedLife) {
            player.drawCards(1, source, game);
        }
        game.informPlayers(player.getLogName() + " notes their life total of " + player.getLife());
        game.getState().setValue(key, (Object)player.getLife());
        return true;
    }
}

