/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Iterator;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SigilBlessingBoostControlledEffect
extends ContinuousEffectImpl {
    SigilBlessingBoostControlledEffect() {
        super(Duration.EndOfTurn, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Until end of turn, target creature you control gets +3/+3 and other creatures you control get +1/+1";
    }

    private SigilBlessingBoostControlledEffect(SigilBlessingBoostControlledEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SigilBlessingBoostControlledEffect copy() {
        return new SigilBlessingBoostControlledEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
            this.affectedObjectList.add(new MageObjectReference((MageObject)perm, game));
        }
    }

    public boolean apply(Game game, Ability source) {
        Iterator it = this.affectedObjectList.iterator();
        while (it.hasNext()) {
            Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
            if (permanent != null) {
                int boost = 1;
                if (permanent.getId().equals(this.getTargetPointer().getFirst(game, source))) {
                    boost = 3;
                }
                permanent.addPower(boost);
                permanent.addToughness(boost);
                continue;
            }
            it.remove();
        }
        return true;
    }
}

