/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SigilCaptainTriggeredAbility
extends TriggeredAbilityImpl {
    public SigilCaptainTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance(2)));
    }

    private SigilCaptainTriggeredAbility(SigilCaptainTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null) {
            return false;
        }
        if (permanent.isControlledBy(this.controllerId) && permanent.getPower().getValue() == 1 && permanent.getToughness().getValue() == 1) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
            }
            return true;
        }
        return false;
    }

    public SigilCaptainTriggeredAbility copy() {
        return new SigilCaptainTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature you control enters, if that creature is 1/1, put two +1/+1 counters on it.";
    }
}

