/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class SignalTheClansEffect
extends SearchEffect {
    SignalTheClansEffect() {
        super(new TargetCardInLibrary(3, (FilterCard)StaticFilters.FILTER_CARD_CREATURE), Outcome.DrawCard);
        this.staticText = "Search your library for three creature cards and reveal them. If you reveal three cards with different names, choose one of them at random and put that card into your hand. Shuffle the rest into your library";
    }

    private SignalTheClansEffect(SignalTheClansEffect effect) {
        super((SearchEffect)effect);
    }

    public SignalTheClansEffect copy() {
        return new SignalTheClansEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (controller.searchLibrary(this.target, source, game)) {
            boolean shuffleDone = false;
            if (!this.target.getTargets().isEmpty()) {
                CardsImpl cards = new CardsImpl((Collection)this.target.getTargets());
                controller.revealCards(source, (Cards)cards, game);
                Card[] cardsArray = cards.getCards(game).toArray(new Card[0]);
                if (Stream.of(cardsArray).map(MageObject::getName).collect(Collectors.toSet()).size() == 3) {
                    Card randomCard = cards.getRandom(game);
                    controller.moveCards(randomCard, Zone.HAND, source, game);
                    cards.remove(randomCard);
                }
                if (!cards.isEmpty()) {
                    controller.shuffleCardsToLibrary((Cards)cards, game, source);
                    shuffleDone = true;
                }
            }
            if (!shuffleDone) {
                controller.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }
}

