/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ModifiedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SignatureSlamEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("modified creature you control");

    SignatureSlamEffect() {
        super(Outcome.Damage);
        this.staticText = ", then each modified creature you control deals damage equal to its power to target creature you don't control";
    }

    private SignatureSlamEffect(SignatureSlamEffect effect) {
        super((OneShotEffect)effect);
    }

    public SignatureSlamEffect copy() {
        return new SignatureSlamEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller == null || targetCreature == null) {
            return false;
        }
        boolean result = false;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, controller.getId(), game)) {
            result |= 0 < targetCreature.damage(permanent.getPower().getValue(), permanent.getId(), source, game);
        }
        return result;
    }

    static {
        filter.add((Predicate)ModifiedPredicate.instance);
    }
}

