/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;

class SigurdJarlOfRavensthorpeTriggeredAbility
extends TriggeredAbilityImpl {
    SigurdJarlOfRavensthorpeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()));
        this.addTarget((Target)new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_ANOTHER_TARGET_CREATURE));
        this.setTriggerPhrase("Whenever you put a lore counter on a Saga you control, ");
    }

    private SigurdJarlOfRavensthorpeTriggeredAbility(SigurdJarlOfRavensthorpeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SigurdJarlOfRavensthorpeTriggeredAbility copy() {
        return new SigurdJarlOfRavensthorpeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null) {
            permanent = game.getPermanentEntering(event.getTargetId());
        }
        return permanent != null && permanent.hasSubtype(SubType.SAGA, game) && permanent.isControlledBy(this.getControllerId()) && CounterType.LORE.getName().equals(event.getData()) && this.isControlledBy(event.getPlayerId());
    }
}

