/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.watchers.common.SpellsCastWatcher;

class SilburlindSnapperEffect
extends RestrictionEffect {
    SilburlindSnapperEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack unless you've cast a noncreature spell this turn";
    }

    private SilburlindSnapperEffect(SilburlindSnapperEffect effect) {
        super((RestrictionEffect)effect);
    }

    public SilburlindSnapperEffect copy() {
        return new SilburlindSnapperEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            List spellsCast;
            SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
            if (watcher != null && (spellsCast = watcher.getSpellsCastThisTurn(source.getControllerId())) != null) {
                for (Spell spell : spellsCast) {
                    if (spell.isCreature(game)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

