/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SilverBoltEffect
extends OneShotEffect {
    SilverBoltEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals 3 damage to target creature. If a Werewolf is dealt damage this way, destroy it";
    }

    private SilverBoltEffect(SilverBoltEffect effect) {
        super((OneShotEffect)effect);
    }

    public SilverBoltEffect copy() {
        return new SilverBoltEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (permanent.damage(3, source, game) > 0 && permanent.hasSubtype(SubType.WEREWOLF, game)) {
            permanent.destroy(source, game, false);
        }
        return true;
    }
}

