/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SingeMindOgreEffect
extends OneShotEffect {
    SingeMindOgreEffect() {
        super(Outcome.LoseLife);
        this.staticText = "target player reveals a card at random from their hand, then loses life equal to that card's mana value";
    }

    private SingeMindOgreEffect(SingeMindOgreEffect effect) {
        super((OneShotEffect)effect);
    }

    public SingeMindOgreEffect copy() {
        return new SingeMindOgreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer != null && !targetPlayer.getHand().isEmpty()) {
            CardsImpl revealed = new CardsImpl();
            Card card = targetPlayer.getHand().getRandom(game);
            if (card != null) {
                revealed.add(card);
                targetPlayer.revealCards("Singe-Mind Ogre", (Cards)revealed, game);
                targetPlayer.loseLife(card.getManaValue(), game, source, false);
                return true;
            }
        }
        return false;
    }
}

