/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.game.Game;
import mage.players.Player;

class SinsOfTheFatherEffect
extends OneShotEffect {
    private static final FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard();

    public SinsOfTheFatherEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile target player's graveyard. That player loses 1 life for each instant or sorcery card exiled this way";
    }

    private SinsOfTheFatherEffect(SinsOfTheFatherEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (you != null && targetPlayer != null) {
            int exiledCards = 0;
            for (Card card : targetPlayer.getGraveyard().getCards(game)) {
                if (!filter.match(card, game) || !card.moveToExile(null, "", source, game)) continue;
                ++exiledCards;
            }
            targetPlayer.loseLife(exiledCards, game, source, false);
            return true;
        }
        return false;
    }

    public SinsOfTheFatherEffect copy() {
        return new SinsOfTheFatherEffect(this);
    }
}

