/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class SiroccoEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("blue instant card");

    SiroccoEffect() {
        super(Outcome.Benefit);
        this.staticText = "target player reveals their hand. For each blue instant card revealed this way, that player discards that card unless they pay 4 life";
    }

    private SiroccoEffect(SiroccoEffect effect) {
        super((OneShotEffect)effect);
    }

    public SiroccoEffect copy() {
        return new SiroccoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null || player.getHand().isEmpty()) {
            return false;
        }
        player.revealCards(source, player.getHand(), game);
        Set cards = player.getHand().getCards(filter, game);
        if (cards.isEmpty()) {
            return true;
        }
        for (Card card : cards) {
            PayLifeCost cost = new PayLifeCost(4);
            if (cost.canPay(source, source, player.getId(), game) && player.chooseUse(this.outcome, "Pay 4 life or discard " + card.getIdName() + '?', null, "Pay life", "Discard", source, game) && cost.pay(source, game, source, player.getId(), true)) continue;
            player.discard(card, false, source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)CardType.INSTANT.getPredicate());
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLUE));
    }
}

